//ZoneBricks - Pack 1 - Made By Melting Plastic (id 799)
//To be Used With The Zone Events Add-on

//Updated 10/26/11 - fixed Loading onPlant vs onLoadPlant.
//Updated 10/27/11 - Fixed Ladders Loading Finally, Slight Code Optimizations.
//Updated 3/9/12   - Fixed Ladders and force gate for sure this time.


datablock fxDTSBrickData (brickzoneTrampData : brick8x8fData)
{
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "Trampoline";
	alwaysShowWireFrame = false;
};


datablock fxDTSBrickData (brickzonemudData : brick8x8fData)
{
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "Mud";
	alwaysShowWireFrame = false;
};


datablock fxDTSBrickData (brickzoneAirventData : brick6x6fData)
{
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "Air Vent";
   alwaysShowWireFrame = false;
};


datablock fxDTSBrickData (brickzoneBoosterData)
{
	brickFile = "base/data/Bricks/special/vehicleSpawn.blb";
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "Booster";
	iconName = "Add-Ons/Brick_Zones/Booster";
   alwaysShowWireFrame = false;
};
datablock fxDTSBrickData (brickzoneVehicleBoosterData)
{
	brickFile = "base/data/Bricks/special/vehicleSpawn.blb";
	category = "ZoneBricks";
	subCategory = "Vehicles";
	uiName = "Vehicle Booster";
	iconName = "base/client/ui/brickIcons/Vehicle Spawn";
	alwaysShowWireFrame = false;
};
datablock fxDTSBrickData (brickzoneForceGateData : brick1x4x5data)
{
	brickFile = "./ForceGate.blb";
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "Force Gate";
   alwaysShowWireFrame = false;
};

datablock fxDTSBrickData (brickzoneConveyorBeltData)
{
	brickFile = "./ConveyorBelt.blb";
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "ConveyorBelt";
	iconName = "Add-Ons/Brick_Zones/ConveyorBelt";
   alwaysShowWireFrame = false;
	
};

datablock fxDTSBrickData (brickzonenoGravData : brick8xCubeData)
{
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "Zero Gravity Zone";
   alwaysShowWireFrame = false;
	isWaterBrick = true;
	
};

datablock fxDTSBrickData (brickzoneSludgeData : brick8xWaterData)
{
	//brickFile = "./8x Zone Cube.blb";
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "8x8 Sludge Water";
	iconName = "Add-Ons/Brick_Large_Cubes/8x Water";
   	alwaysShowWireFrame = true;
};

datablock fxDTSBrickData (brickzoneWaterFallData : brick8xWaterData)
{
	//brickFile = "./8x Zone Cube.blb";
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "8x8 WaterFall";
	iconName = "Add-Ons/Brick_Large_Cubes/8x Water";
   	alwaysShowWireFrame = true;
};

datablock fxDTSBrickData (brickzone1x4x5 : brick1x4x5data)
{
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "1x4x5 Zone Brick";
	
	
   alwaysShowWireFrame = false;
};

datablock fxDTSBrickData (brickzoneLadderup)
{
	brickFile = "./Ladder.blb";
	category = "ZoneBricks";
	subCategory = "Players/Bots";
	uiName = "1x2x5 Ladder Helper";
	iconName = "base/client/ui/brickicons/1x2x5";
   	alwaysShowWireFrame = True;
	
};


datablock fxDTSBrickData (brickzone8x8 : brick8xCubeData)
{
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "8x8 Zone Cube";
	
   alwaysShowWireFrame = false;
	isWaterBrick = true;
};

datablock fxDTSBrickData (brickzone16x16 : brick16xCubeData)
{
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "16x16 Zone Cube";
   alwaysShowWireFrame = false;
	isWaterBrick = true;
};

datablock fxDTSBrickData (brickzone32x32 : brick32xCubeData)
{
	
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "32x32 Zone Cube";
   alwaysShowWireFrame = false;
	isWaterBrick = true;
};

datablock fxDTSBrickData (brickzone64x64 : brick64xCubeData)
{
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "64x64 Zone Cube";
   alwaysShowWireFrame = false;
	isWaterBrick = true;
};


datablock fxDTSBrickData (brickzone4x4f : brick4x4fData)
{
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "4x4 Zone plate";
   alwaysShowWireFrame = false;
	
};

datablock fxDTSBrickData (brickzone2x4f : brick2x4fData)
{
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "2x4 Zone Plate";
   alwaysShowWireFrame = false;
	
};

datablock fxDTSBrickData (brickzone8x8f : brick8x8fData)
{
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "8x8 Zone Plate";
   alwaysShowWireFrame = false;
	
};

datablock fxDTSBrickData (brickzone4x8f : brick4x8fData)
{
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "4x8 Zone Plate";
   alwaysShowWireFrame = false;
	
};

datablock fxDTSBrickData (brickzone6x12f : brick6x12fData)
{
	category = "ZoneBricks";
	subCategory = "Basic";
	uiName = "6x12 Zone Plate";
   alwaysShowWireFrame = false;
	
};
//zonebricks package/////////////////////////////////////////////////////////////////////////////////////////////////
package Zonebricks
{


////////////////////////////////////////////////////////
function brickzonemudData::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzonemudData::LoadParameters(%this);
}
function brickzonemudData::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzonemudData::LoadParameters(%this);
}
function brickzonemudData::LoadParameters(%this)
{
	%this.setZone(1, 1, "0 0 0", %this.client);
	%this.setZoneDrag(11, %this.client);
}
//////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
function brickzoneAirVentData::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzoneAirVentData::LoadParameters(%this);
}
function brickzoneAirVentData::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzoneAirVentData::LoadParameters(%this);
}
function brickzoneAirVentData::LoadParameters(%this)
{
	%this.setZone(1, 10, "0 0 4000", %this.client);
}
/////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////
function brickzoneBoosterData::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzoneBoosterData::LoadParameters(%this);
}
function brickzoneBoosterData::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzoneBoosterData::LoadParameters(%this);
}
function brickzoneBoosterData::LoadParameters(%this)
{
	%this.setZone(1, 1, "0 0 0", %this.client);
	%this.physicalZone.setAppliedForce(vectorScale(%this.getForwardVector(), 7000));
}
/////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////
function brickzoneVehicleBoosterData::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzoneVehicleBoosterData::LoadParameters(%this);
}
function brickzoneVehicleBoosterData::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzoneVehicleBoosterData::LoadParameters(%this);
}
function brickzoneVehicleBoosterData::LoadParameters(%this)
{
	%this.setZone(1, 8, "0 0 0", %this.client);
	%this.physicalZone.setAppliedForce(vectorScale(%this.getForwardVector(), 20000));
}
/////////////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////
function brickzoneForceGateData::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzoneForceGateData::LoadParameters(%this);
}
function brickzoneForceGateData::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzoneForceGateData::LoadParameters(%this);
}
function brickzoneForceGateData::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.physicalZone.setAppliedForce(vectorScale(-getword(%this.getForwardVector(),1) SPC getword(%this.getForwardVector(),0) SPC getword(%this.getForwardVector(),2), 9000));
	%this.setColliding(0);
	%this.setRendering(0);
    %this.setRayCasting(0);
}	
/////////////////////////////////////////////////////////////////////////////////////////////////////
	
	
	
	
	
	
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////
function brickzoneConveyorBeltData::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzoneConveyorBeltData::LoadParameters(%this);
}
function brickzoneConveyorBeltData::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzoneConveyorBeltData::LoadParameters(%this);
}
function brickzoneConveyorBeltData::LoadParameters(%this)
{
	%this.setZone(1, 1, "0 0 0", %this.client);
	%this.physicalZone.setAppliedForce(vectorScale(%this.getForwardVector(), 3700));
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function brickzonenoGravData::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzonenoGravData::LoadParameters(%this);
}
function brickzonenoGravData::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzonenoGravData::LoadParameters(%this);
}
function brickzonenoGravData::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setZoneGravity(0.0, %this.client);   
	%this.setColliding(0);
	%this.setRendering(0);
	%this.setRayCasting(0);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////
function brickzoneSludgeData::onplant(%data,%this)
{
	brick8xWaterData::onPlant(%data,%this);
	brickzoneSludgeData::LoadParameters(%this);
}
function brickzoneSludgeData::onLoadplant(%data,%this)
{
		brick8xWaterData::onLoadPlant(%data,%this);
		brickzoneSludgeData::LoadParameters(%this);	
}
function brickzoneSludgeData::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(1);
    %this.setRayCasting(0);
    %this.setShapeFX(2);
	%this.schedule(100,"setZoneisWater",1,%this.client);
	%this.schedule(150,"setZoneWaterViscosity",180, %this.client);
}	
//////////////////////////////////////////////////////////////////////////////




/////////////////////////////////////////////////////////////////////////////////
function brickzoneWaterFallData::onplant(%data,%this)
{
	brick8xWaterData::onPlant(%data,%this);
	brickzoneWaterFallData::LoadParameters(%this);
}
function brickzoneWaterFallData::onLoadplant(%data,%this)
{
	brick8xWaterData::onLoadPlant(%data,%this);
	brickzoneWaterFallData::LoadParameters(%this);
}
function brickzoneWaterFallData::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 -7000", %this.client);
	%this.setColliding(0);
	%this.setRendering(1);
    %this.setRayCasting(0);
    %this.setShapeFX(2);
	%this.schedule(100,"setZoneisWater",1,%this.client);	
}
///////////////////////////////////////////////////////////////////////////////////////


	
//////////////////////////////////////////////////////////////
function brickzone1x4x5::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzone1x4x5::LoadParameters(%this);	
}
function brickzone1x4x5::onLoadplant(%data,%this)
{	
	Parent::onLoadPlant(%this);
	brickzone1x4x5::LoadParameters(%this);
}
function brickzone1x4x5::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
    %this.setRayCasting(0);
}
///////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
function brickzoneLadderup::onplant(%data,%this)
{
    Parent::onPlant(%this);
	brickzoneLadderup::LoadParameters(%this);
}
function brickzoneLadderup::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzoneLadderup::LoadParameters(%this);
}
function brickzoneLadderup::LoadParameters(%this)
{
	%ForwardVector = vectorScale(%this.getForwardVector(), 1000);
    %x = getword(%ForwardVector, 0);
    %y = getword(%ForwardVector, 1);
    %z = getword(%ForwardVector, 2);
    
	//swaped and inversed to get correct orientation.
    %this.setZone(0, 0, -%y SPC -%x SPC 3000, %this.client);
    %this.setZoneDrag(2, %this.client);
    %this.setColliding(0);
    %this.setRendering(0);
    %this.setRayCasting(0);
}
///////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////
function brickzone8x8::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzone8x8::LoadParameters(%this);
}
function brickzone8x8::onLoadplant(%data,%this)
{	
	Parent::onLoadPlant(%this);
	brickzone8x8::LoadParameters(%this);
}
function brickzone8x8::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
    %this.setRayCasting(0);
}
/////////////////////////////////////////////////////
	
	
	
////////////////////////////////////////////////////////
function brickzone16x16::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzone16x16::LoadParameters(%this);
}
function brickzone16x16::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzone16x16::LoadParameters(%this);
}
function brickzone16x16::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
    %this.setRayCasting(0);
}
///////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////
function brickzone32x32::onplant(%data,%this)
{	
	Parent::onPlant(%this);
	brickzone32x32::LoadParameters(%this);
}
function brickzone32x32::onLoadplant(%data,%this)
{	
	Parent::onLoadPlant(%this);
	brickzone32x32::LoadParameters(%this);
}
function brickzone32x32::LoadParameters(%this)
{	
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
	%this.setRayCasting(0);
}
/////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
function brickzone64x64::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzone64x64::LoadParameters(%this);
}
function brickzone64x64::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzone64x64::LoadParameters(%this);
}
function brickzone64x64::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
	%this.setRayCasting(0);
}
/////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
function brickzone4x4f::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzone4x4f::LoadParameters(%this);
}
function brickzone4x4f::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzone4x4f::LoadParameters(%this);
}
function brickzone4x4f::LoadParameters(%this)
{	
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
	%this.setRayCasting(0);
}
//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
function brickzone2x4f::onplant(%data,%this)
{
	
	Parent::onPlant(%this);
	brickzone2x4f::LoadParameters(%this);
}
function brickzone2x4f::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzone2x4f::LoadParameters(%this);
	
}
function brickzone2x4f::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
    %this.setRayCasting(0);
}
////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
function brickzone8x8f::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzone8x8f::LoadParameters(%this);
}
function brickzone8x8f::onLoadplant(%data,%this)
{
	Parent::onLoadplant(%this);
	brickzone8x8f::LoadParameters(%this);	
}
function brickzone8x8f::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
    %this.setRayCasting(0);
}
////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
function brickzone4x8f::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzone4x8f::LoadParameters(%this);
}
function brickzone4x8f::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzone4x8f::LoadParameters(%this);
}
function brickzone4x8f::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
	%this.setRayCasting(0);
}
////////////////////////////////////////////////////////////////////////////////////////








//////////////////////////////////////////////////////////////////////////////////////////
function brickzone6x12f::onplant(%data,%this)
{
	Parent::onPlant(%this);
	brickzone6x12f::LoadParameters(%this);
}
function brickzone6x12f::onLoadplant(%data,%this)
{
	Parent::onLoadPlant(%this);
	brickzone6x12f::LoadParameters(%this);
}
function brickzone6x12f::LoadParameters(%this)
{
	%this.setZone(0, 0, "0 0 0", %this.client);
	%this.setColliding(0);
	%this.setRendering(0);
	%this.setRayCasting(0);
}
////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////
function brickzoneTrampData::onplant(%data,%this)
{	
	Parent::onPlant(%this);
	brickzoneTrampData::LoadParameters(%this);
}
function brickzoneTrampData::onLoadplant(%data,%this)
{	
	Parent::onLoadplant(%this);
	brickzoneTrampData::LoadParameters(%this);
}
function brickzoneTrampData::LoadParameters(%this)
{	
	%this.setZone(1, 1, "0 0 30000", %this.client);
}
///////////////////////////////////////////////////////////////////////////////////////


};

activatePackage(Zonebricks);